/* rygel-ruih-servicemanager.c generated by valac 0.30.1, the Vala compiler
 * generated from rygel-ruih-servicemanager.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Neha Shanbhag <N.Shanbhag@cablelabs.com>
 * Contact: http://www.cablelabs.com/
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <rygel-core.h>


#define RYGEL_TYPE_RUIH_SERVICE_MANAGER (rygel_ruih_service_manager_get_type ())
#define RYGEL_RUIH_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManager))
#define RYGEL_RUIH_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManagerClass))
#define RYGEL_IS_RUIH_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER))
#define RYGEL_IS_RUIH_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RUIH_SERVICE_MANAGER))
#define RYGEL_RUIH_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManagerClass))

typedef struct _RygelRuihServiceManager RygelRuihServiceManager;
typedef struct _RygelRuihServiceManagerClass RygelRuihServiceManagerClass;
typedef struct _RygelRuihServiceManagerPrivate RygelRuihServiceManagerPrivate;

#define TYPE_UI_LISTING (ui_listing_get_type ())
#define UI_LISTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UI_LISTING, UIListing))
#define UI_LISTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UI_LISTING, UIListingClass))
#define IS_UI_LISTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UI_LISTING))
#define IS_UI_LISTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UI_LISTING))
#define UI_LISTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UI_LISTING, UIListingClass))

typedef struct _UIListing UIListing;
typedef struct _UIListingClass UIListingClass;

#define TYPE_UI_ELEM (ui_elem_get_type ())
#define UI_ELEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UI_ELEM, UIElem))
#define UI_ELEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UI_ELEM, UIElemClass))
#define IS_UI_ELEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UI_ELEM))
#define IS_UI_ELEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UI_ELEM))
#define UI_ELEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UI_ELEM, UIElemClass))

typedef struct _UIElem UIElem;
typedef struct _UIElemClass UIElemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_xml_utils_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_xml_utils_iterator_unref (var), NULL)))
#define _ui_listing_unref0(var) ((var == NULL) ? NULL : (var = (ui_listing_unref (var), NULL)))

#define TYPE_FILTER_ENTRY (filter_entry_get_type ())
#define FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_ENTRY, FilterEntry))
#define FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_ENTRY, FilterEntryClass))
#define IS_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_ENTRY))
#define IS_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_ENTRY))
#define FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_ENTRY, FilterEntryClass))

typedef struct _FilterEntry FilterEntry;
typedef struct _FilterEntryClass FilterEntryClass;
#define _filter_entry_unref0(var) ((var == NULL) ? NULL : (var = (filter_entry_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_WILD_CARD_FILTER_ENTRY (wild_card_filter_entry_get_type ())
#define WILD_CARD_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntry))
#define WILD_CARD_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntryClass))
#define IS_WILD_CARD_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WILD_CARD_FILTER_ENTRY))
#define IS_WILD_CARD_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WILD_CARD_FILTER_ENTRY))
#define WILD_CARD_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntryClass))

typedef struct _WildCardFilterEntry WildCardFilterEntry;
typedef struct _WildCardFilterEntryClass WildCardFilterEntryClass;

struct _RygelRuihServiceManager {
	GObject parent_instance;
	RygelRuihServiceManagerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelRuihServiceManagerClass {
	GObjectClass parent_class;
};

struct _RygelRuihServiceManagerPrivate {
	GeeArrayList* ui_list;
	gchar* ui_listing_full_path;
	GFileMonitor* ui_file_monitor;
};

struct _Block1Data {
	int _ref_count_;
	RygelRuihServiceManager* self;
	GFile* ui_file;
};

typedef enum  {
	RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED = 701,
	RYGEL_RUIH_SERVICE_ERROR_INVALID_FILTER = 702
} RygelRuihServiceError;
#define RYGEL_RUIH_SERVICE_ERROR rygel_ruih_service_error_quark ()

static gpointer rygel_ruih_service_manager_parent_class = NULL;
static gchar* rygel_ruih_service_manager_PRE_RESULT;
static gchar* rygel_ruih_service_manager_PRE_RESULT = NULL;
static gchar* rygel_ruih_service_manager_POST_RESULT;
static gchar* rygel_ruih_service_manager_POST_RESULT = NULL;
static RygelRuihServiceManager* rygel_ruih_service_manager_instance;
static RygelRuihServiceManager* rygel_ruih_service_manager_instance = NULL;

GType rygel_ruih_service_manager_get_type (void) G_GNUC_CONST;
gpointer ui_listing_ref (gpointer instance);
void ui_listing_unref (gpointer instance);
GParamSpec* param_spec_ui_listing (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ui_listing (GValue* value, gpointer v_object);
void value_take_ui_listing (GValue* value, gpointer v_object);
gpointer value_get_ui_listing (const GValue* value);
GType ui_listing_get_type (void) G_GNUC_CONST;
GType ui_elem_get_type (void) G_GNUC_CONST;
#define RYGEL_RUIH_SERVICE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManagerPrivate))
enum  {
	RYGEL_RUIH_SERVICE_MANAGER_DUMMY_PROPERTY
};
#define RYGEL_RUIH_SERVICE_MANAGER_UILIST "uilist"
#define RYGEL_RUIH_SERVICE_MANAGER_DEVICEPROFILE "deviceprofile"
#define RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL "protocol"
#define RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO "protocolInfo"
#define RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME "shortName"
#define RYGEL_RUIH_SERVICE_MANAGER_UI "ui"
#define RYGEL_RUIH_SERVICE_MANAGER_UI_LISTING_FILE_NAME "UIList.xml"
RygelRuihServiceManager* rygel_ruih_service_manager_get_default (void);
RygelRuihServiceManager* rygel_ruih_service_manager_new (void);
RygelRuihServiceManager* rygel_ruih_service_manager_construct (GType object_type);
static void rygel_ruih_service_manager_real_constructed (GObject* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GQuark rygel_ruih_service_error_quark (void);
void rygel_ruih_service_manager_set_ui_list (RygelRuihServiceManager* self, const gchar* ui_list_file_path, GError** error);
static void ___lambda4_ (Block1Data* _data1_, GFile* src, GFile* dest, GFileMonitorEvent event);
static void ____lambda4__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
gboolean rygel_ruih_service_manager_ui_list_available (RygelRuihServiceManager* self);
UIElem* ui_elem_new (xmlNode* node, GError** error);
UIElem* ui_elem_construct (GType object_type, xmlNode* node, GError** error);
gchar* rygel_ruih_service_manager_get_compatible_uis (RygelRuihServiceManager* self, const gchar* device_profile, const gchar* filter, GError** error);
gpointer filter_entry_ref (gpointer instance);
void filter_entry_unref (gpointer instance);
GParamSpec* param_spec_filter_entry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_filter_entry (GValue* value, gpointer v_object);
void value_take_filter_entry (GValue* value, gpointer v_object);
gpointer value_get_filter_entry (const GValue* value);
GType filter_entry_get_type (void) G_GNUC_CONST;
FilterEntry* filter_entry_new (const gchar* name, const gchar* value);
FilterEntry* filter_entry_construct (GType object_type, const gchar* name, const gchar* value);
static void rygel_ruih_service_manager_convert_device_profile_to_filter (RygelRuihServiceManager* self, xmlNode* node, GeeList* filter_entries);
static void rygel_ruih_service_manager_convert_filter_string (RygelRuihServiceManager* self, xmlNode* device_profile_node, const gchar* filter, GeeList* filter_entries, GError** error);
gchar* ui_listing_to_ui_listing (UIListing* self, GeeArrayList* filters);
WildCardFilterEntry* wild_card_filter_entry_new (void);
WildCardFilterEntry* wild_card_filter_entry_construct (GType object_type);
GType wild_card_filter_entry_get_type (void) G_GNUC_CONST;
static void rygel_ruih_service_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelRuihServiceManager* rygel_ruih_service_manager_get_default (void) {
	RygelRuihServiceManager* result = NULL;
	RygelRuihServiceManager* _tmp0_ = NULL;
	RygelRuihServiceManager* _tmp2_ = NULL;
	RygelRuihServiceManager* _tmp3_ = NULL;
	_tmp0_ = rygel_ruih_service_manager_instance;
	if (_tmp0_ == NULL) {
		RygelRuihServiceManager* _tmp1_ = NULL;
		_tmp1_ = rygel_ruih_service_manager_new ();
		_g_object_unref0 (rygel_ruih_service_manager_instance);
		rygel_ruih_service_manager_instance = _tmp1_;
	}
	_tmp2_ = rygel_ruih_service_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelRuihServiceManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->ui_file);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GFile* src, GFile* dest, GFileMonitorEvent event) {
	RygelRuihServiceManager* self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (src != NULL);
	_tmp0_ = _data1_->ui_file;
	_tmp1_ = src;
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
	if (_tmp2_) {
		{
			const gchar* _tmp3_ = NULL;
			_tmp3_ = self->priv->ui_listing_full_path;
			rygel_ruih_service_manager_set_ui_list (self, _tmp3_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
					goto __catch3_rygel_ruih_service_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally3;
		__catch3_rygel_ruih_service_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GError* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = _ ("Failed to set UIList for file %s - %s");
			_tmp5_ = self->priv->ui_listing_full_path;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning (_tmp4_, _tmp5_, _tmp7_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_signal_emit_by_name (self, "updated");
	}
}


static void ____lambda4__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	___lambda4_ (self, file, other_file, event_type);
}


static void rygel_ruih_service_manager_real_constructed (GObject* base) {
	RygelRuihServiceManager * self;
	GeeArrayList* _tmp0_ = NULL;
	const gchar* config_dir = NULL;
	const gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	gchar* ui_listing_directory = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelRuihServiceManager*) base;
	G_OBJECT_CLASS (rygel_ruih_service_manager_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (TYPE_UI_ELEM, (GBoxedCopyFunc) ui_listing_ref, ui_listing_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->ui_list);
	self->priv->ui_list = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	config_dir = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp2_;
	_tmp3_ = g_build_filename (config_dir, "Rygel", NULL);
	ui_listing_directory = _tmp3_;
	_tmp4_ = g_build_filename (ui_listing_directory, RYGEL_RUIH_SERVICE_MANAGER_UI_LISTING_FILE_NAME, NULL);
	_g_free0 (self->priv->ui_listing_full_path);
	self->priv->ui_listing_full_path = _tmp4_;
	g_mkdir_with_parents (ui_listing_directory, 0755);
	{
		Block1Data* _data1_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* config_dir_file = NULL;
		GFile* _tmp8_ = NULL;
		GFileMonitor* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GCancellable* _tmp11_ = NULL;
		GFileMonitor* _tmp12_ = NULL;
		GFileMonitor* _tmp13_ = NULL;
		GFileMonitor* _tmp14_ = NULL;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp5_ = self->priv->ui_listing_full_path;
		rygel_ruih_service_manager_set_ui_list (self, _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				goto __catch2_rygel_ruih_service_error;
			}
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_free0 (ui_listing_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = self->priv->ui_listing_full_path;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_data1_->ui_file = _tmp7_;
		_tmp8_ = g_file_new_for_path (ui_listing_directory);
		config_dir_file = _tmp8_;
		_tmp10_ = config_dir_file;
		_tmp11_ = self->cancellable;
		_tmp12_ = g_file_monitor_directory (_tmp10_, G_FILE_MONITOR_NONE, _tmp11_, &_inner_error_);
		_tmp9_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config_dir_file);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				goto __catch2_rygel_ruih_service_error;
			}
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			_g_object_unref0 (config_dir_file);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			_g_free0 (ui_listing_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (self->priv->ui_file_monitor);
		self->priv->ui_file_monitor = _tmp13_;
		_tmp14_ = self->priv->ui_file_monitor;
		g_signal_connect_data (_tmp14_, "changed", (GCallback) ____lambda4__g_file_monitor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (config_dir_file);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	goto __finally2;
	__catch2_rygel_ruih_service_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _ ("Failed to set initial UI list for file %s - %s");
		_tmp16_ = self->priv->ui_listing_full_path;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning (_tmp15_, _tmp16_, _tmp18_);
		_g_error_free0 (e);
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = _ ("Failed to monitor the file %s - %s");
		_tmp20_ = self->priv->ui_listing_full_path;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning (_tmp19_, _tmp20_, _tmp22_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (ui_listing_directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (ui_listing_directory);
}


gboolean rygel_ruih_service_manager_ui_list_available (RygelRuihServiceManager* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ui_list;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}


void rygel_ruih_service_manager_set_ui_list (RygelRuihServiceManager* self, const gchar* ui_list_file_path, GError** error) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	xmlDoc* doc = NULL;
	const gchar* _tmp2_ = NULL;
	xmlDoc* _tmp3_ = NULL;
	xmlDoc* _tmp4_ = NULL;
	xmlNode* ui_list_node = NULL;
	xmlDoc* _tmp13_ = NULL;
	xmlNode* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	xmlNode* _tmp16_ = NULL;
	xmlDoc* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_list_file_path != NULL);
	_tmp0_ = self->priv->ui_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = ui_list_file_path;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = ui_list_file_path;
	_tmp3_ = xmlParseFile (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		gchar* msg = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		_tmp5_ = _ ("Unable to parse UI list file %s");
		_tmp6_ = g_strdup (_tmp5_);
		msg = _tmp6_;
		_tmp7_ = msg;
		_tmp8_ = ui_list_file_path;
		_tmp9_ = g_strdup_printf (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			return;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (msg);
	}
	_tmp13_ = doc;
	_tmp14_ = xmlDocGetRootElement (_tmp13_);
	ui_list_node = _tmp14_;
	_tmp16_ = ui_list_node;
	if (_tmp16_ != NULL) {
		xmlNode* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = ui_list_node;
		_tmp18_ = _tmp17_->name;
		_tmp15_ = g_strcmp0 (_tmp18_, RYGEL_RUIH_SERVICE_MANAGER_UILIST) == 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		{
			RygelXMLUtilsIterator* _node_it = NULL;
			xmlNode* _tmp19_ = NULL;
			RygelXMLUtilsChildIterator* _tmp20_ = NULL;
			RygelXMLUtilsChildIterator* _tmp21_ = NULL;
			RygelXMLUtilsIterator* _tmp22_ = NULL;
			RygelXMLUtilsIterator* _tmp23_ = NULL;
			_tmp19_ = ui_list_node;
			_tmp20_ = rygel_xml_utils_child_iterator_new (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = rygel_xml_utils_iterator_iterator ((RygelXMLUtilsIterator*) _tmp21_);
			_tmp23_ = _tmp22_;
			_rygel_xml_utils_iterator_unref0 (_tmp21_);
			_node_it = _tmp23_;
			while (TRUE) {
				RygelXMLUtilsIterator* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				xmlNode* node = NULL;
				RygelXMLUtilsIterator* _tmp26_ = NULL;
				xmlNode* _tmp27_ = NULL;
				xmlNode* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				_tmp24_ = _node_it;
				_tmp25_ = rygel_xml_utils_iterator_next (_tmp24_);
				if (!_tmp25_) {
					break;
				}
				_tmp26_ = _node_it;
				_tmp27_ = rygel_xml_utils_iterator_get (_tmp26_);
				node = _tmp27_;
				_tmp28_ = node;
				_tmp29_ = _tmp28_->name;
				if (g_strcmp0 (_tmp29_, RYGEL_RUIH_SERVICE_MANAGER_UI) == 0) {
					UIElem* _tmp30_ = NULL;
					xmlNode* _tmp31_ = NULL;
					UIElem* _tmp32_ = NULL;
					GeeArrayList* _tmp33_ = NULL;
					_tmp31_ = node;
					_tmp32_ = ui_elem_new (_tmp31_, &_inner_error_);
					_tmp30_ = _tmp32_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_rygel_xml_utils_iterator_unref0 (_node_it);
							return;
						} else {
							_rygel_xml_utils_iterator_unref0 (_node_it);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp33_ = self->priv->ui_list;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp30_);
					_ui_listing_unref0 (_tmp30_);
				}
			}
			_rygel_xml_utils_iterator_unref0 (_node_it);
		}
	}
	_tmp34_ = doc;
	xmlFreeDoc (_tmp34_);
}


gchar* rygel_ruih_service_manager_get_compatible_uis (RygelRuihServiceManager* self, const gchar* device_profile, const gchar* filter, GError** error) {
	gchar* result = NULL;
	GeeArrayList* filter_entries = NULL;
	GeeArrayList* _tmp0_ = NULL;
	xmlNode* device_profile_node = NULL;
	xmlDoc* doc = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp22_ = FALSE;
	xmlNode* _tmp23_ = NULL;
	xmlNode* _tmp28_ = NULL;
	GeeArrayList* _tmp29_ = NULL;
	xmlNode* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	xmlDoc* _tmp33_ = NULL;
	GString* _result_ = NULL;
	const gchar* _tmp34_ = NULL;
	GString* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	GeeArrayList* _tmp37_ = NULL;
	GString* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	GString* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_profile != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_FILTER_ENTRY, (GBoxedCopyFunc) filter_entry_ref, filter_entry_unref, NULL, NULL, NULL);
	filter_entries = _tmp0_;
	device_profile_node = NULL;
	doc = NULL;
	_tmp2_ = device_profile;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = device_profile;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		xmlDoc* _tmp10_ = NULL;
		xmlDoc* _tmp11_ = NULL;
		xmlDoc* _tmp20_ = NULL;
		xmlNode* _tmp21_ = NULL;
		_tmp6_ = device_profile;
		_tmp7_ = device_profile;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = xmlParseMemory (_tmp6_, _tmp9_);
		doc = _tmp10_;
		_tmp11_ = doc;
		if (_tmp11_ == NULL) {
			gchar* msg = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			GError* _tmp19_ = NULL;
			_tmp12_ = _ ("Unable to parse device profile data: %s");
			_tmp13_ = g_strdup (_tmp12_);
			msg = _tmp13_;
			_tmp14_ = msg;
			_tmp15_ = device_profile;
			_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp17_);
			_tmp19_ = _tmp18_;
			_g_free0 (_tmp17_);
			_inner_error_ = _tmp19_;
			if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				_g_object_unref0 (filter_entries);
				return NULL;
			} else {
				_g_free0 (msg);
				_g_object_unref0 (filter_entries);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
		_tmp20_ = doc;
		_tmp21_ = xmlDocGetRootElement (_tmp20_);
		device_profile_node = _tmp21_;
	}
	_tmp23_ = device_profile_node;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = filter;
		_tmp22_ = g_strcmp0 (_tmp24_, "") == 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GeeArrayList* _tmp25_ = NULL;
		FilterEntry* _tmp26_ = NULL;
		FilterEntry* _tmp27_ = NULL;
		_tmp25_ = filter_entries;
		_tmp26_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME, "*HTML5*");
		_tmp27_ = _tmp26_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp27_);
		_filter_entry_unref0 (_tmp27_);
	}
	_tmp28_ = device_profile_node;
	_tmp29_ = filter_entries;
	rygel_ruih_service_manager_convert_device_profile_to_filter (self, _tmp28_, (GeeList*) _tmp29_);
	_tmp30_ = device_profile_node;
	_tmp31_ = filter;
	_tmp32_ = filter_entries;
	rygel_ruih_service_manager_convert_filter_string (self, _tmp30_, _tmp31_, (GeeList*) _tmp32_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (filter_entries);
			return NULL;
		} else {
			_g_object_unref0 (filter_entries);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp33_ = doc;
	xmlFreeDoc (_tmp33_);
	_tmp34_ = rygel_ruih_service_manager_PRE_RESULT;
	_tmp35_ = g_string_new (_tmp34_);
	_result_ = _tmp35_;
	_tmp37_ = self->priv->ui_list;
	if (_tmp37_ != NULL) {
		GeeArrayList* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		_tmp38_ = self->priv->ui_list;
		_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp36_ = _tmp40_ > 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GString* result_content = NULL;
		GString* _tmp41_ = NULL;
		GString* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		GString* _tmp61_ = NULL;
		GString* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		_tmp41_ = g_string_new ("");
		result_content = _tmp41_;
		{
			GeeArrayList* _ui_list = NULL;
			GeeArrayList* _tmp42_ = NULL;
			GeeArrayList* _tmp43_ = NULL;
			gint _ui_size = 0;
			GeeArrayList* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gint _ui_index = 0;
			_tmp42_ = self->priv->ui_list;
			_tmp43_ = _g_object_ref0 (_tmp42_);
			_ui_list = _tmp43_;
			_tmp44_ = _ui_list;
			_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_ui_size = _tmp46_;
			_ui_index = -1;
			while (TRUE) {
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				UIElem* ui = NULL;
				GeeArrayList* _tmp50_ = NULL;
				gint _tmp51_ = 0;
				gpointer _tmp52_ = NULL;
				GString* _tmp53_ = NULL;
				UIElem* _tmp54_ = NULL;
				GeeArrayList* _tmp55_ = NULL;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				_tmp47_ = _ui_index;
				_ui_index = _tmp47_ + 1;
				_tmp48_ = _ui_index;
				_tmp49_ = _ui_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _ui_list;
				_tmp51_ = _ui_index;
				_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _tmp51_);
				ui = (UIElem*) _tmp52_;
				_tmp53_ = result_content;
				_tmp54_ = ui;
				_tmp55_ = filter_entries;
				_tmp56_ = ui_listing_to_ui_listing ((UIListing*) _tmp54_, _tmp55_);
				_tmp57_ = _tmp56_;
				g_string_append (_tmp53_, _tmp57_);
				_g_free0 (_tmp57_);
				_ui_listing_unref0 (ui);
			}
			_g_object_unref0 (_ui_list);
		}
		_tmp58_ = result_content;
		_tmp59_ = _tmp58_->str;
		if (g_strcmp0 (_tmp59_, "") == 0) {
			gchar* _tmp60_ = NULL;
			_tmp60_ = g_strdup ("");
			result = _tmp60_;
			_g_string_free0 (result_content);
			_g_string_free0 (_result_);
			_g_object_unref0 (filter_entries);
			return result;
		}
		_tmp61_ = _result_;
		_tmp62_ = result_content;
		_tmp63_ = _tmp62_->str;
		g_string_append (_tmp61_, _tmp63_);
		_g_string_free0 (result_content);
	}
	_tmp64_ = _result_;
	_tmp65_ = rygel_ruih_service_manager_POST_RESULT;
	g_string_append (_tmp64_, _tmp65_);
	_tmp66_ = _result_;
	_tmp67_ = _tmp66_->str;
	_tmp68_ = g_strdup (_tmp67_);
	result = _tmp68_;
	_g_string_free0 (_result_);
	_g_object_unref0 (filter_entries);
	return result;
}


static void rygel_ruih_service_manager_convert_device_profile_to_filter (RygelRuihServiceManager* self, xmlNode* node, GeeList* filter_entries) {
	gboolean _tmp0_ = FALSE;
	xmlNode* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter_entries != NULL);
	_tmp1_ = node;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		xmlNode* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->name;
		_tmp0_ = g_strcmp0 (_tmp3_, RYGEL_RUIH_SERVICE_MANAGER_DEVICEPROFILE) != 0;
	}
	if (_tmp0_) {
		return;
	}
	{
		RygelXMLUtilsIterator* _child_node_it = NULL;
		xmlNode* _tmp4_ = NULL;
		RygelXMLUtilsChildIterator* _tmp5_ = NULL;
		RygelXMLUtilsChildIterator* _tmp6_ = NULL;
		RygelXMLUtilsIterator* _tmp7_ = NULL;
		RygelXMLUtilsIterator* _tmp8_ = NULL;
		_tmp4_ = node;
		_tmp5_ = rygel_xml_utils_child_iterator_new (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = rygel_xml_utils_iterator_iterator ((RygelXMLUtilsIterator*) _tmp6_);
		_tmp8_ = _tmp7_;
		_rygel_xml_utils_iterator_unref0 (_tmp6_);
		_child_node_it = _tmp8_;
		while (TRUE) {
			RygelXMLUtilsIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			xmlNode* child_node = NULL;
			RygelXMLUtilsIterator* _tmp11_ = NULL;
			xmlNode* _tmp12_ = NULL;
			xmlNode* _tmp13_ = NULL;
			xmlElementType _tmp14_ = 0;
			xmlNode* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gboolean _tmp35_ = FALSE;
			xmlNode* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			_tmp9_ = _child_node_it;
			_tmp10_ = rygel_xml_utils_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _child_node_it;
			_tmp12_ = rygel_xml_utils_iterator_get (_tmp11_);
			child_node = _tmp12_;
			_tmp13_ = child_node;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == XML_TEXT_NODE) {
				continue;
			}
			_tmp15_ = child_node;
			_tmp16_ = _tmp15_->name;
			if (g_strcmp0 (_tmp16_, RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL) == 0) {
				{
					xmlAttr* prop = NULL;
					xmlNode* _tmp17_ = NULL;
					xmlAttr* _tmp18_ = NULL;
					_tmp17_ = child_node;
					_tmp18_ = _tmp17_->properties;
					prop = _tmp18_;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							xmlAttr* _tmp22_ = NULL;
							gboolean _tmp23_ = FALSE;
							xmlAttr* _tmp24_ = NULL;
							const gchar* _tmp25_ = NULL;
							if (!_tmp19_) {
								xmlAttr* _tmp20_ = NULL;
								xmlAttr* _tmp21_ = NULL;
								_tmp20_ = prop;
								_tmp21_ = _tmp20_->next;
								prop = _tmp21_;
							}
							_tmp19_ = FALSE;
							_tmp22_ = prop;
							if (!(_tmp22_ != NULL)) {
								break;
							}
							_tmp24_ = prop;
							_tmp25_ = _tmp24_->name;
							if (g_strcmp0 (_tmp25_, RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME) == 0) {
								xmlAttr* _tmp26_ = NULL;
								xmlNode* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								_tmp26_ = prop;
								_tmp27_ = _tmp26_->children;
								_tmp28_ = _tmp27_->content;
								_tmp23_ = _tmp28_ != NULL;
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								FilterEntry* entry = NULL;
								xmlAttr* _tmp29_ = NULL;
								xmlNode* _tmp30_ = NULL;
								const gchar* _tmp31_ = NULL;
								FilterEntry* _tmp32_ = NULL;
								GeeList* _tmp33_ = NULL;
								FilterEntry* _tmp34_ = NULL;
								_tmp29_ = prop;
								_tmp30_ = _tmp29_->children;
								_tmp31_ = _tmp30_->content;
								_tmp32_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME, _tmp31_);
								entry = _tmp32_;
								_tmp33_ = filter_entries;
								_tmp34_ = entry;
								gee_collection_add ((GeeCollection*) _tmp33_, _tmp34_);
								_filter_entry_unref0 (entry);
							}
						}
					}
				}
			}
			_tmp36_ = child_node;
			_tmp37_ = _tmp36_->name;
			if (g_strcmp0 (_tmp37_, RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO) == 0) {
				xmlNode* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				_tmp38_ = child_node;
				_tmp39_ = _tmp38_->content;
				_tmp35_ = _tmp39_ != NULL;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				FilterEntry* entry = NULL;
				xmlNode* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				FilterEntry* _tmp42_ = NULL;
				GeeList* _tmp43_ = NULL;
				FilterEntry* _tmp44_ = NULL;
				_tmp40_ = child_node;
				_tmp41_ = _tmp40_->content;
				_tmp42_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO, _tmp41_);
				entry = _tmp42_;
				_tmp43_ = filter_entries;
				_tmp44_ = entry;
				gee_collection_add ((GeeCollection*) _tmp43_, _tmp44_);
				_filter_entry_unref0 (entry);
			}
		}
		_rygel_xml_utils_iterator_unref0 (_child_node_it);
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void rygel_ruih_service_manager_convert_filter_string (RygelRuihServiceManager* self, xmlNode* device_profile_node, const gchar* filter, GeeList* filter_entries, GError** error) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean filter_is_wildcard = FALSE;
	gboolean _tmp6_ = FALSE;
	xmlNode* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	g_return_if_fail (filter_entries != NULL);
	_tmp0_ = filter;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp4_ = filter;
	if (g_strcmp0 (_tmp4_, "*") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = filter;
		_tmp3_ = g_strcmp0 (_tmp5_, "\"*\"") == 0;
	}
	filter_is_wildcard = _tmp3_;
	_tmp7_ = device_profile_node;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		_tmp8_ = filter_is_wildcard;
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeeList* _tmp9_ = NULL;
		WildCardFilterEntry* _tmp10_ = NULL;
		WildCardFilterEntry* _tmp11_ = NULL;
		_tmp9_ = filter_entries;
		_tmp10_ = wild_card_filter_entry_new ();
		_tmp11_ = _tmp10_;
		gee_collection_add ((GeeCollection*) _tmp9_, (FilterEntry*) _tmp11_);
		_filter_entry_unref0 (_tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		_tmp12_ = filter_is_wildcard;
		if (!_tmp12_) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gunichar _tmp16_ = 0U;
			gchar** entries = NULL;
			const gchar* _tmp41_ = NULL;
			gchar** _tmp42_ = NULL;
			gchar** _tmp43_ = NULL;
			gint entries_length1 = 0;
			gint _entries_size_ = 0;
			gchar** _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			_tmp15_ = filter;
			_tmp16_ = string_get_char (_tmp15_, (glong) 0);
			if (_tmp16_ != ((gunichar) '"')) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gunichar _tmp22_ = 0U;
				_tmp18_ = filter;
				_tmp19_ = filter;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_get_char (_tmp18_, (glong) (_tmp21_ - 1));
				if (_tmp22_ != ((gunichar) '"')) {
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					gunichar _tmp27_ = 0U;
					_tmp23_ = filter;
					_tmp24_ = filter;
					_tmp25_ = strlen (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = string_get_char (_tmp23_, (glong) (_tmp26_ - 1));
					_tmp17_ = _tmp27_ != ((gunichar) ',');
				} else {
					_tmp17_ = FALSE;
				}
				_tmp14_ = _tmp17_;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp28_ = FALSE;
				const gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp29_ = filter;
				_tmp30_ = string_contains (_tmp29_, ",");
				if (!_tmp30_) {
					const gchar* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = filter;
					_tmp32_ = string_contains (_tmp31_, ";");
					_tmp28_ = _tmp32_;
				} else {
					_tmp28_ = FALSE;
				}
				_tmp13_ = _tmp28_;
			}
			if (_tmp13_) {
				gchar* msg = NULL;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				GError* _tmp39_ = NULL;
				GError* _tmp40_ = NULL;
				_tmp33_ = _ ("Invalid UI filter: %s");
				_tmp34_ = g_strdup (_tmp33_);
				msg = _tmp34_;
				_tmp35_ = msg;
				_tmp36_ = filter;
				_tmp37_ = g_strdup_printf (_tmp35_, _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_INVALID_FILTER, _tmp38_);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				_inner_error_ = _tmp40_;
				if (_inner_error_->domain == RYGEL_RUIH_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (msg);
			}
			_tmp41_ = filter;
			_tmp43_ = _tmp42_ = g_strsplit (_tmp41_, ",", 0);
			entries = _tmp43_;
			entries_length1 = _vala_array_length (_tmp42_);
			_entries_size_ = entries_length1;
			_tmp44_ = entries;
			_tmp44__length1 = entries_length1;
			{
				gchar** str_collection = NULL;
				gint str_collection_length1 = 0;
				gint _str_collection_size_ = 0;
				gint str_it = 0;
				str_collection = _tmp44_;
				str_collection_length1 = _tmp44__length1;
				for (str_it = 0; str_it < _tmp44__length1; str_it = str_it + 1) {
					const gchar* str = NULL;
					str = str_collection[str_it];
					{
						const gchar* _tmp45_ = NULL;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						gchar** name_value = NULL;
						const gchar* _tmp48_ = NULL;
						gchar** _tmp49_ = NULL;
						gchar** _tmp50_ = NULL;
						gint name_value_length1 = 0;
						gint _name_value_size_ = 0;
						gboolean _tmp51_ = FALSE;
						gboolean _tmp52_ = FALSE;
						gboolean _tmp53_ = FALSE;
						gchar** _tmp54_ = NULL;
						gint _tmp54__length1 = 0;
						_tmp45_ = str;
						_tmp46_ = strlen (_tmp45_);
						_tmp47_ = _tmp46_;
						if (_tmp47_ == 0) {
							continue;
						}
						_tmp48_ = str;
						_tmp50_ = _tmp49_ = g_strsplit (_tmp48_, "=", 0);
						name_value = _tmp50_;
						name_value_length1 = _vala_array_length (_tmp49_);
						_name_value_size_ = name_value_length1;
						_tmp54_ = name_value;
						_tmp54__length1 = name_value_length1;
						if (_tmp54_ != NULL) {
							gchar** _tmp55_ = NULL;
							gint _tmp55__length1 = 0;
							_tmp55_ = name_value;
							_tmp55__length1 = name_value_length1;
							_tmp53_ = _tmp55__length1 == 2;
						} else {
							_tmp53_ = FALSE;
						}
						if (_tmp53_) {
							gchar** _tmp56_ = NULL;
							gint _tmp56__length1 = 0;
							const gchar* _tmp57_ = NULL;
							_tmp56_ = name_value;
							_tmp56__length1 = name_value_length1;
							_tmp57_ = _tmp56_[1];
							_tmp52_ = _tmp57_ != NULL;
						} else {
							_tmp52_ = FALSE;
						}
						if (_tmp52_) {
							gchar** _tmp58_ = NULL;
							gint _tmp58__length1 = 0;
							const gchar* _tmp59_ = NULL;
							gint _tmp60_ = 0;
							gint _tmp61_ = 0;
							_tmp58_ = name_value;
							_tmp58__length1 = name_value_length1;
							_tmp59_ = _tmp58_[1];
							_tmp60_ = strlen (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp51_ = _tmp61_ > 2;
						} else {
							_tmp51_ = FALSE;
						}
						if (_tmp51_) {
							gboolean _tmp62_ = FALSE;
							gchar** _tmp63_ = NULL;
							gint _tmp63__length1 = 0;
							const gchar* _tmp64_ = NULL;
							gunichar _tmp65_ = 0U;
							_tmp63_ = name_value;
							_tmp63__length1 = name_value_length1;
							_tmp64_ = _tmp63_[1];
							_tmp65_ = string_get_char (_tmp64_, (glong) 0);
							if (_tmp65_ == ((gunichar) '"')) {
								gchar** _tmp66_ = NULL;
								gint _tmp66__length1 = 0;
								const gchar* _tmp67_ = NULL;
								gchar** _tmp68_ = NULL;
								gint _tmp68__length1 = 0;
								const gchar* _tmp69_ = NULL;
								gint _tmp70_ = 0;
								gint _tmp71_ = 0;
								gunichar _tmp72_ = 0U;
								_tmp66_ = name_value;
								_tmp66__length1 = name_value_length1;
								_tmp67_ = _tmp66_[1];
								_tmp68_ = name_value;
								_tmp68__length1 = name_value_length1;
								_tmp69_ = _tmp68_[1];
								_tmp70_ = strlen (_tmp69_);
								_tmp71_ = _tmp70_;
								_tmp72_ = string_get_char (_tmp67_, (glong) (_tmp71_ - 1));
								_tmp62_ = _tmp72_ == ((gunichar) '"');
							} else {
								_tmp62_ = FALSE;
							}
							if (_tmp62_) {
								gchar* value = NULL;
								gchar** _tmp73_ = NULL;
								gint _tmp73__length1 = 0;
								const gchar* _tmp74_ = NULL;
								gchar** _tmp75_ = NULL;
								gint _tmp75__length1 = 0;
								const gchar* _tmp76_ = NULL;
								gint _tmp77_ = 0;
								gint _tmp78_ = 0;
								gchar* _tmp79_ = NULL;
								GeeList* _tmp80_ = NULL;
								gchar** _tmp81_ = NULL;
								gint _tmp81__length1 = 0;
								const gchar* _tmp82_ = NULL;
								const gchar* _tmp83_ = NULL;
								FilterEntry* _tmp84_ = NULL;
								FilterEntry* _tmp85_ = NULL;
								_tmp73_ = name_value;
								_tmp73__length1 = name_value_length1;
								_tmp74_ = _tmp73_[1];
								_tmp75_ = name_value;
								_tmp75__length1 = name_value_length1;
								_tmp76_ = _tmp75_[1];
								_tmp77_ = strlen (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = string_substring (_tmp74_, (glong) 1, (glong) (_tmp78_ - 1));
								value = _tmp79_;
								_tmp80_ = filter_entries;
								_tmp81_ = name_value;
								_tmp81__length1 = name_value_length1;
								_tmp82_ = _tmp81_[0];
								_tmp83_ = value;
								_tmp84_ = filter_entry_new (_tmp82_, _tmp83_);
								_tmp85_ = _tmp84_;
								gee_collection_add ((GeeCollection*) _tmp80_, _tmp85_);
								_filter_entry_unref0 (_tmp85_);
								_g_free0 (value);
							}
						}
						name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}


RygelRuihServiceManager* rygel_ruih_service_manager_construct (GType object_type) {
	RygelRuihServiceManager * self = NULL;
	self = (RygelRuihServiceManager*) g_object_new (object_type, NULL);
	return self;
}


RygelRuihServiceManager* rygel_ruih_service_manager_new (void) {
	return rygel_ruih_service_manager_construct (RYGEL_TYPE_RUIH_SERVICE_MANAGER);
}


static void rygel_ruih_service_manager_class_init (RygelRuihServiceManagerClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	rygel_ruih_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelRuihServiceManagerPrivate));
	((GObjectClass *) klass)->constructed = rygel_ruih_service_manager_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_ruih_service_manager_finalize;
	g_signal_new ("updated", RYGEL_TYPE_RUIH_SERVICE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" "<" RYGEL_RUIH_SERVICE_MANAGER_UILIST " xmlns=\"urn:schemas-upnp-org:remoteui:uilist-1-0\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:remoteui:uilist-1-0 " "CompatibleUIs.xsd\">\n");
	rygel_ruih_service_manager_PRE_RESULT = _tmp0_;
	_tmp1_ = g_strdup ("</" RYGEL_RUIH_SERVICE_MANAGER_UILIST ">\n");
	rygel_ruih_service_manager_POST_RESULT = _tmp1_;
}


static void rygel_ruih_service_manager_instance_init (RygelRuihServiceManager * self) {
	self->priv = RYGEL_RUIH_SERVICE_MANAGER_GET_PRIVATE (self);
}


static void rygel_ruih_service_manager_finalize (GObject* obj) {
	RygelRuihServiceManager * self;
	GCancellable* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManager);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->ui_list);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->priv->ui_listing_full_path);
	_g_object_unref0 (self->priv->ui_file_monitor);
	G_OBJECT_CLASS (rygel_ruih_service_manager_parent_class)->finalize (obj);
}


GType rygel_ruih_service_manager_get_type (void) {
	static volatile gsize rygel_ruih_service_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_ruih_service_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRuihServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_ruih_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRuihServiceManager), 0, (GInstanceInitFunc) rygel_ruih_service_manager_instance_init, NULL };
		GType rygel_ruih_service_manager_type_id;
		rygel_ruih_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRuihServiceManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_ruih_service_manager_type_id__volatile, rygel_ruih_service_manager_type_id);
	}
	return rygel_ruih_service_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



